<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.internal_name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.code') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.created_at') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column class="flex items-center">
                <a href="{{ route('daylight.settings.countries.edit', ['country' => $row]) }}">
                    <img src="{{ daylightAsset('resources/assets/images/flags/'.strtolower($row->code).'.svg') }}" alt="{{ $row->name }}" class="inline-block h-5 w-5 rounded-full ring-2 ring-white mr-2">
                    {{ $row->name }}
                </a>

                @if($row->default)
                    <p class="text-gray-400 ml-8">{{ __('daylight::general.default_country') }}</p>
                @endif
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->code }}
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->created_at->isoFormat('LLL') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.settings.countries.edit', ['country' => $row]) }}"
                   class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    Edit
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
