<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.country') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::store.orders') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.total_spend') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.created_at') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column class="flex items-center">
                <a href="{{ route('daylight.store.customers.show', $row) }}">
                    {{ $row->name }}
                </a>
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ $row->defaultBillingAddress?->country?->name ?? __('daylight::general.n_a') }}
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ $row->orders_count }}
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ formatPrice($row->orders_sum_total / 100) }}
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ $row->created_at->isoFormat('LLL') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.customers.show', $row) }}"
                   class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    {{{ __('daylight::general.view_details') }}}
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
