<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.number') }}
        </th>

        @if(!in_array('customer', $hiddenColumns ?? []))
            <th class="p-3 text-left text-sm font-semibold text-gray-900">
                {{ __('daylight::store.customer') }}
            </th>
        @endif

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.status') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::store.mail.total') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('daylight::general.placed_at') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column class="flex items-center">
                <a href="{{ route('daylight.store.orders.show', $row) }}">
                    #{{ $row->number }}
                </a>
            </x-daylight::tables.column>
            @if(!in_array('customer', $hiddenColumns ?? []))
                <x-daylight::tables.column>
                    {{ $row->customer->name }}
                </x-daylight::tables.column>
            @endif
            <x-daylight::tables.column>
               <x-daylight::badge :class="$row->status->adminColor()">
                   {{ $row->status->label() }}
               </x-daylight::badge>
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ formatPrice($row->total) }}
            </x-daylight::tables.column>
            <x-daylight::tables.column>
                {{ $row->created_at->format('d-m-Y H:i') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.orders.show', $row) }}"
                   class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    {{{ __('daylight::general.view_details') }}}
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
