<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\CustomerGroup;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class CustomerGroupTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return CustomerGroup::query();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query
                ->where('code', 'like', "%{$searchQuery}%")
                ->orWhere('name', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.customer-group-table');
    }
}
