<?php

namespace Daylight\Core\Livewire\Tables\Concerns;

use Livewire\Attributes\Computed;

trait WithBulkActions
{
    public bool $bulkActions = true;

    public ?string $bulkAction = null;

    public function updatedBulkAction(): void
    {
        if (is_null($this->bulkAction)) {
            return;
        }

        if (in_array($this->bulkAction, array_keys($this->availableBulkActions()))) {
            $this->{$this->availableBulkActions()[$this->bulkAction]['action']}();
        }

        $this->reset('bulkAction');
    }

    #[Computed]
    abstract protected function availableBulkActions(): array;
}
