<?php

namespace Daylight\Core\Models\Enums;

enum CustomerType: string
{
    case PERSONAL = 'personal';

    case COMPANY = 'company';

    public function label(): string
    {
        return match ($this) {
            self::PERSONAL => __('Individual'),
            self::COMPANY => __('Company'),
        };
    }
}
