<?php

namespace Daylight\Core\Modules\PageBuilder\Registries;

use Daylight\Core\Modules\PageBuilder\Entities\Template;
use Illuminate\Support\Collection;

class TemplateRegistry
{
    protected Collection $templates;

    public function __construct()
    {
        $this->templates = collect();
    }

    public function register(Template $template): self
    {
        $this->templates->put($template->getKey(), $template);

        return $this;
    }

    public static function addTemplate(Template $template): self
    {
        return app(TemplateRegistry::class)->register($template);
    }

    public function all(): Collection
    {
        return $this->templates;
    }
}
