<?php

namespace Daylight\Core\Modules\Payment\Contracts;

use Daylight\Core\Models\Order;
use Daylight\Core\Modules\Payment\Entities\PaymentIntent;

interface PaymentBuilder
{
    public function forOrder(Order $order): self;

    public function withoutPreferredPaymentMethod(): self;

    public function setPaymentMethod(string $paymentMethod): self;

    public function create(): PaymentIntent;

    public function cancel(): bool;
}
