<x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
    <x-daylight::tables.column class="flex items-center">
        <a href="{{ route('daylight.store.categories.edit', $row) }}" style="margin-left: {{ $level * 16 }}px">
            {{ $row->name }}
        </a>
    </x-daylight::tables.column>

    <x-daylight::tables.column>
        {{ $row->created_at->isoFormat('LLL') }}
    </x-daylight::tables.column>

    <x-slot:actions>
        <a href="{{ route('daylight.store.categories.edit', $row) }}"
           class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
            {{ __('daylight::general.edit') }}
        </a>
    </x-slot:actions>
</x-daylight::tables.row>

@if($row->children->isNotEmpty())
    @foreach($row->children as $child)
        @include('daylight::store.categories.partials.category', ['row' => $child, 'level' => $level + 1])
    @endforeach
@endif
