@extends('daylight::layouts.app')

@section('title', __('Create customer group'))

@section('content')
    <x-daylight::page-header :title="__('Create customer group')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.store.customer-groups.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('daylight::general.name')"
            :error="$errors->first('name')"
            for="code"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('daylight::general.default')"
            :error="$errors->first('default')"
            for="default"
        >
            <div x-data="{ selected: {{ old('default') ? '1' : '0' }}}">
                <div class="flex items-center mt-1">
                    <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                            @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                            class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                            role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                    </button>
                    <span class="ml-3 text-sm font-medium text-gray-900"
                          id="annual-billing-label">{{ __('daylight::general.default') }}</span>
                </div>

                <input type="hidden" name="default" x-model="selected">
            </div>
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.store.customer-groups.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
