<?php

namespace Daylight\Core\Http\Requests\Settings\Roles;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRoleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:advanced-settings');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'unique:roles,name,' . $this->route('role')->id],
            'permissions' => ['array'],
            'permissions.*' => ['exists:permissions,id'],
        ];
    }
}
