<?php

namespace Daylight\Core\Modules\Admin\Registries;

use Daylight\Core\Modules\Admin\Entities\Shortcut;
use Illuminate\Support\Collection;

class ShortcutRegistry
{
    protected Collection $items;

    public function __construct()
    {
        $this->items = collect();
    }

    public static function addShortcut(Shortcut $shortcut): self
    {
        return app(self::class)->register($shortcut);
    }

    public function register(array|Collection|Shortcut $items): self
    {
        if ($items instanceof Shortcut) {
            $items = [$items];
        }

        if (is_array($items)) {
            $items = collect($items);
        }

        $this->items = $this->items->merge($items);

        return $this;
    }

    public function all(): Collection
    {
        return $this->items->filter(function (Shortcut $widget) {
            return auth()->user()->can($widget->getPermission());
        })->sortBy('order')->values();
    }
}
