<?php

namespace Daylight\Core\Modules\MenuBuilder\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MenuTranslation extends Model
{
    protected $guarded = [];

    public function menu(): HasMany
    {
        return $this->hasMany(Menu::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(MenuItem::class)
            ->orderBy('order');
    }
}
