import slug from 'alpinejs-slug'
import sort from '@alpinejs/sort'
import { Livewire, Alpine } from '../../../vendor/livewire/livewire/dist/livewire.esm';
import Sortable from 'sortablejs';
import { initAlpineWysiwyg } from "./modules/PageBuilder/alpineWysiwyg.js";

// Global Alpine WYSIWYG initialization
initAlpineWysiwyg();

// Make Sortable available globally
window.Sortable = Sortable;

import.meta.glob([
    '../images/**',
]);

Alpine.plugin(slug)
Alpine.plugin(sort)
Livewire.start()

if (typeof window.alpineWysiwyg === 'undefined') {
    initAlpineWysiwyg();
}
