<div
        class="px-6 mt-6"
        x-data="optionValueBuilder(option)"
        @save-option-value.window="saveOptionValue()"
        @sync-option-values.window="syncArrayWithDOM()"
>
    <h3 class="mb-6">{{ __('daylight::store.option_values') }}</h3>

    <div x-ref="sortableContainer" class="list">
        <template x-for="(optionValue, index) in option.optionValues" :key="optionValue.id">
            <div :data-option-value-id="optionValue.id" class="flex items-center justify-between p-4 mb-2 border rounded">
                <div class="flex items-center">
                    <svg class="sortable-handle w-4 h-4 mr-3 text-gray-400 cursor-move" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 7.5 7.5 3m0 0L12 7.5M7.5 3v13.5m13.5 0L16.5 21m0 0L12 16.5m4.5 4.5V7.5"></path>
                    </svg>

                    <div class="flex items-center">
                        <div class="text-sm">
                            <span x-text="optionValue.translations[currentLocale].name"></span>

                            <template x-if="option.type === 'swatches' && optionValue.color">
                                <div class="text-xs mt-1 text-gray-400 flex items-center">
                                    <p class="size-3 rounded-full border mr-1" :style="{ backgroundColor: optionValue.color }"></p>
                                    <p x-text="optionValue.color"/>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>

                <div class="flex items-center gap-3">
                    <button @click.prevent="currentOptionValue = optionValue; isCreatingNew = false; showOptionValueSlideOver = true;"
                            class="p-2 bg-gray-200 rounded-full hover:bg-sky-600 hover:text-white transition">
                        <svg class="w-4 h-4" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor"
                             viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                  d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10"></path>
                        </svg>
                    </button>

                    <button @click.prevent="deleteOptionValue(optionValue.id)"
                            class="p-2 bg-gray-200 rounded-full hover:bg-red-500 hover:text-white transition">
                        <svg class="w-4 h-4" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor"
                             viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </template>
    </div>

    <button @click.prevent="createOptionValue" type="button"
            class="rounded-md mt-4 w-full border border-dashed border-gray-300 hover:border-gray-700 transition text-gray-500  hover:text-gray-900 py-5 font-semibold text-sm flex items-center justify-center">
        <svg class="w-4 h-4 mr-3" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor"
             viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path stroke-linecap="round" stroke-linejoin="round"
                  d="M12 9v6m3-3H9m12 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"></path>
        </svg>

        {{ __('daylight::store.add_new_value') }}
    </button>

    <x-daylight::variation-builder.option-value-slide-over/>
</div>
