<?php

namespace Daylight\Core\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class PublishAssets extends Command
{
    protected $signature = 'daylight:publish-assets';

    protected $description = 'Copy Daylight assets to the public directory';

    public function handle()
    {
        $link = public_path('vendor/daylight');

        if (file_exists($link)) {
            unlink($link);
        }

        File::ensureDirectoryExists(dirname($link));

        symlink(base_path('vendor/daylight/core/dist/'), $link);
    }
}
