<?php

namespace Daylight\Core\Modules\MediaLibrary\Livewire;

use Daylight\Core\Modules\MediaLibrary\Models\Directory;
use Illuminate\View\View;
use Livewire\Attributes\Computed;
use Livewire\Component;

class DirectoryHeader extends Component
{
    public ?int $directoryId = null;

    public string $search = '';

    public function updatedSearch(): void
    {
        $this->dispatch('search-updated', $this->search);
    }

    #[Computed]
    public function currentDirectory(): ?Directory
    {
        return $this->directoryId ? Directory::query()->find($this->directoryId) : null;
    }

    public function goUp(): void
    {
        $parentId = $this->currentDirectory()?->parent_id;
        $this->dispatch('change-current-directory', $parentId);
    }

    public function goRoot(): void
    {
        $this->dispatch('change-current-directory', null);
    }

    public function render(): View
    {
        return view('daylight::livewire.media.directory-header');
    }
}
