@props([
    'name' => __('daylight::general.options')
])
<div class="relative inline-block text-left mr-2" x-data="{ open: false }">
    <div>
        <button
            @click.prevent="open = !open"
            type="button"
            class="py-2.5 px-4 border rounded-md flex items-center leading-5 font-medium transition duration-150 ease-in-out bg-white text-gray-600 hover:bg-gray-100 border-gray-300 text-sm"
            id="menu-button"
            aria-expanded="true"
            aria-haspopup="true">

            {{ $name }}

            <svg class="ml-2 -mr-1 h-5 w-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z" clip-rule="evenodd"/>
            </svg>
        </button>
    </div>

    <div x-show="open" x-cloak @click.away="open = false"
        x-transition:enter="transition ease-out duration-100"
        x-transition:enter-start="transform opacity-0 scale-95"
        x-transition:enter-end="transform opacity-100 scale-100"
        x-transition:leave="transition ease-in duration-75"
        x-transition:leave-start="transform opacity-100 scale-100"
        x-transition:leave-end="transform opacity-0 scale-95"
        class="absolute right-0 z-10 mt-2 w-56 origin-top-right rounded-md bg-white shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
        role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1">
        <div class="py-1" role="none">
            {{ $slot }}
        </div>
    </div>
</div>
