<?php

namespace Daylight\Core\Models\Enums;

enum ShippingMethod: string
{
    case PICKUP = 'pickup';

    case SHIPPING = 'shipping';

    public function label(): string
    {
        return match ($this) {
            self::PICKUP => __('Pickup'),
            self::SHIPPING => __('Shipping'),
        };
    }
}
