<?php

namespace Daylight\Core\Services;

use Daylight\Core\Models\Country;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;

class Countries
{
    public static function all(): Collection
    {
        return Cache::rememberForever('countries', function () {
            return (daylightModel('country'))::query()
                ->whereStatus(1)
                ->with([
                    'taxRates',
                    'shippingZones',
                ])
                ->get();
        });
    }

    public static function defaultCountry(): Country
    {
        return static::all()
            ->where('default', 1)
            ->first();
    }
}
