@props([
    'items' => []
])


<div class="bg-gray-100 -mx-4 px-4 -mt-4 p-4 mb-4">
    <select
        @change="window.location.href = event.target.value"
        class="h-10 text-sm block w-full rounded-md border-0 py-1.5 pl-3 pr-10 text-gray-900 ring-1 ring-inset ring-gray-300 focus:ring-2 focus:ring-indigo-600 sm:text-sm sm:leading-6">
        @foreach($items as $item)
            @if($item->getType() === 'divider')
                <option disabled>────────</option>
            @else
                <option {{ $item->isActive() ? 'selected' : '' }} value="{{ $item->getUrl() }}">
                    {{ $item->getLabel() }}
                </option>
                @if($item->getChildren()->isNotEmpty())
                    @foreach($item->getChildren() as $child)
                        @if($child->getType() !== 'divider')
                            <option {{ $child->isActive() ? 'selected' : '' }} value="{{ $child->getUrl() }}">
                                &nbsp;&nbsp;&nbsp;&nbsp;{{ $child->getLabel() }}
                            </option>
                        @endif
                    @endforeach
                @endif
            @endif
        @endforeach
    </select>
</div>