@extends('daylight::layouts.app')

@section('title', __('daylight::store.create_category'))

@section('content')
    <x-daylight::page-header :title="__('daylight::store.create_category')"/>

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.store.categories.store') }}">
        @csrf

        <input type="hidden" name="locale" value="{{ request()->get('locale', app()->getLocale()) }}">

        <x-daylight::input.group
                :label="__('daylight::general.parent')"
                :error="$errors->first('parent')"
                for="parent_id"
        >
            <x-daylight::input.select name="parent_id" id="parent_id"
                                      :disabled="!auth()->user()->can('update:categories')" searchable>
                <option value="">{{ __('daylight::store.no_parent') }}</option>
                @foreach($parents as $parent)
                    @include('daylight::store.categories.partials.parent', ['parent' => $parent, 'level' => 0])
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('daylight::general.order')"
                :error="$errors->first('order')"
                for="order"
        >
            <x-daylight::input.text
                    name="order"
                    id="order"
                    value="{{ old('order', 100) }}"
                    :disabled="!auth()->user()->can('update:categories')"
            />
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('daylight::store.display')"
                :error="$errors->first('display')"
                for="display"
        >
            <x-daylight::input.select name="display" id="display">
                @foreach(\Daylight\Core\Models\Enums\DisplayType::formattedValues() as $key => $value)
                    <option value="{{ $key }}" @if(old('display', 'products') == $key) selected @endif>{{ $value }}</option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
                :label="__('daylight::store.manual_sorting')"
                :error="$errors->first('manual_sorting')"
                for="manual_sorting"
        >
            <x-daylight::input.select name="manual_sorting" id="manual_sorting">
                <option value="0" @if(old('manual_sorting', '0') == $key) selected @endif>{{ __('daylight::general.no') }}</option>
                <option value="1" @if(old('manual_sorting', '1') == $key) selected @endif>{{ __('daylight::general.yes') }}</option>
            </x-daylight::input.select>
        </x-daylight::input.group>


        <x-daylight::locale-selector :route="route('daylight.store.categories.create')"/>

        <div x-data="{ name: '{{ old('name') }}', slug: '{{ old('slug') }}' }">
            <x-daylight::input.group
                    :label="__('daylight::general.name')"
                    :error="$errors->first('name')"
                    for="code"
            >
                <x-daylight::input.text
                        name="name"
                        id="name"
                        value="{{ old('name') }}"
                        :disabled="!auth()->user()->can('update:categories')"
                        x-model="name"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                    :label="__('daylight::general.slug')"
                    :error="$errors->first('slug')"
                    for="slug"
            >
                <x-daylight::input.text
                        name="slug"
                        id="slug"
                        value="{{ old('slug') }}"
                        :disabled="!auth()->user()->can('update:categories')"
                        x-slug="name"
                />
            </x-daylight::input.group>
        </div>

        <x-daylight::seo/>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.store.categories.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
