<?php

namespace Daylight\Core\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class ScoutSyncSettingsCommands extends Command
{
    protected $signature = 'daylight:scout:sync-settings';

    protected $description = 'Shortcut to sync all index settings for Laravel Scout (Meilisearch)';

    public function handle(): int
    {
        Artisan::call('scout:sync-index-settings');

        $this->info('Scout settings synced.');

        return Command::SUCCESS;
    }
}
