<?php

namespace Daylight\Core\Http\Controllers\Settings;

use Daylight\Core\Http\Controllers\Controller;
use Daylight\Core\Http\Requests\Settings\ShippingClasses\StoreShippingClassRequest;
use Daylight\Core\Http\Requests\Settings\ShippingClasses\UpdateShippingClassRequest;
use Daylight\Core\Models\Shipping\ShippingClass;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class ShippingClassController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:update:advanced-settings', only: ['create', 'store', 'update', 'destroy']),
            new Middleware('can:read:advanced-settings', only: ['index', 'show', 'edit']),
        ];
    }

    public function index()
    {
        return view('daylight::settings.shipping-classes.index');
    }

    public function create()
    {
        return view('daylight::settings.shipping-classes.create', [
            'taxClasses' => daylightModel('tax_class')::get(),
        ]);
    }

    public function store(StoreShippingClassRequest $request)
    {
        $shippingClass = (daylightModel('shipping_class'))::create($request->validated());

        return redirect()->route('daylight.settings.shipping-classes.edit', $shippingClass)
            ->with('success', __('Shipping class created'));
    }

    public function edit(ShippingClass $shippingClass)
    {
        return view('daylight::settings.shipping-classes.edit', [
            'shippingClass' => $shippingClass,
            'taxClasses' => daylightModel('tax_class')::get(),
        ]);
    }

    public function update(UpdateShippingClassRequest $request, ShippingClass $shippingClass)
    {
        $shippingClass->update($request->validated());

        return redirect()->route('daylight.settings.shipping-classes.index')
            ->with('success', __('Shipping class updated'));
    }

    public function destroy(ShippingClass $shippingClass)
    {
        $shippingClass->delete();

        return redirect()->route('daylight.settings.shipping-classes.index')
            ->with('success', __('Shipping class deleted'));
    }
}
