<?php

namespace Daylight\Core\Http\Requests\Store\API;

use Illuminate\Foundation\Http\FormRequest;

class SearchVariantRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('read:products');
    }

    public function rules(): array
    {
        return [
            'searchQuery' => ['required', 'string', 'max:255'],
        ];
    }
}
