<?php

namespace Daylight\Core\Http\Requests\Store\Variants;

use Illuminate\Foundation\Http\FormRequest;

class UpdateVariantRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:variants');
    }

    public function rules(): array
    {
        return [
            'gallery' => ['nullable', 'array'],
            'gallery.*.id' => ['exists:media,id'],
            'video_url' => ['nullable', 'string', 'url'],
        ];
    }

    public function prepareForValidation(): void
    {
        $this->merge([
            'gallery' => json_decode($this->input('gallery'), true),
        ]);
    }
}
