<?php

namespace Daylight\Core\Livewire\Tables\Concerns;

use Illuminate\Database\Eloquent\Builder;

trait WithSearch
{
    public bool $searchable = true;

    public ?string $searchQuery = null;

    abstract protected function applySearch(Builder $query, ?string $searchQuery): Builder;

    public function getSearchQueryArgument(): string
    {
        return 'searchQuery';
    }

    protected function queryString(): array
    {
        return [
            'searchQuery' => [
                'as' => $this->getSearchQueryArgument(),
            ],
        ];
    }
}
