<?php

namespace Daylight\Core\Models\Enums;

enum StockStatus: string
{
    case IN_STOCK = 'IN_STOCK';

    case OUT_OF_STOCK = 'OUT_OF_STOCK';

    case BACKORDER = 'BACKORDER';

    public function getLabel(): string
    {
        return match ($this) {
            StockStatus::IN_STOCK => __('In stock'),
            StockStatus::OUT_OF_STOCK => __('Out of stock'),
            StockStatus::BACKORDER => __('In backorder'),
        };
    }
}
