<?php

namespace Daylight\Core\Modules\PageBuilder;

use Daylight\Core\Modules\PageBuilder\Livewire\PageBuilder;
use Daylight\Core\Modules\PageBuilder\Registries\ComponentRegistry;
use Daylight\Core\Modules\PageBuilder\Registries\TemplateRegistry;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class PageBuilderServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->app->singleton(ComponentRegistry::class, function () {
            return new ComponentRegistry;
        });

        $this->app->singleton(TemplateRegistry::class, function () {
            return new TemplateRegistry;
        });

        $this->registerLivewireComponents();
    }

    protected function registerLivewireComponents(): void
    {
        if (! class_exists(Livewire::class)) {
            return;
        }

        Livewire::component('daylight::page-builder', PageBuilder::class);
        Livewire::component('daylight::related-field-selector', \Daylight\Core\Modules\PageBuilder\Livewire\RelatedFieldSelector::class);
    }
}
