<?php

namespace Daylight\Core\Modules\Payment\Enums;

use Daylight\Core\Models\Enums\OrderStatus;

enum PaymentStatus: string
{
    case OPEN = 'open';

    case PENDING = 'pending';

    case AUTHORIZED = 'authorized';

    case PAID = 'paid';

    case CANCELED = 'canceled';

    case EXPIRED = 'expired';

    case FAILED = 'failed';

    public function label(): string
    {
        return match ($this) {
            self::OPEN => __('Open'),
            self::PENDING => __('Pending'),
            self::AUTHORIZED => __('Authorized'),
            self::PAID => __('Paid'),
            self::CANCELED => __('Canceled'),
            self::EXPIRED => __('Expired'),
            self::FAILED => __('Failed'),
        };
    }

    public function getOrderStatus(): OrderStatus
    {
        return match ($this) {
            self::OPEN => OrderStatus::AWAITING_PAYMENT,
            self::PENDING => OrderStatus::PENDING,
            self::AUTHORIZED => OrderStatus::PENDING,
            self::PAID => OrderStatus::PROCESSING,
            self::CANCELED => OrderStatus::CANCELLED,
            self::EXPIRED => OrderStatus::FAILED,
            self::FAILED => OrderStatus::FAILED,
        };
    }

    public function adminColor(): string
    {
        return match ($this) {
            self::OPEN => 'bg-blue-50 text-blue-700',
            self::PENDING => 'bg-yellow-50 text-yellow-700',
            self::AUTHORIZED => 'bg-green-50 text-green-700',
            self::PAID => 'bg-green-50 text-green-700',
            self::CANCELED => 'bg-gray-50 text-gray-700',
            self::EXPIRED => 'bg-gray-50 text-gray-700',
            self::FAILED => 'bg-red-50 text-red-700',
            default => 'bg-red-50 text-red-700',
        };
    }
}
