<?php

namespace Daylight\Core\Http\Requests\Settings\ShippingZones;

use Illuminate\Foundation\Http\FormRequest;

class StoreShippingZoneRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:settings');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'countries' => ['required', 'array'],
            'countries.*' => ['required', 'string', 'exists:countries,id'],
            'rules' => ['required', 'array'],
            'rules.*.*.price' => ['required', 'numeric'],
            'max_amount' => ['nullable', 'numeric'],
            'free_shipping_above' => ['nullable', 'numeric'],
        ];
    }
}
