<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('media', function (Blueprint $table) {
            // Add missing columns if they don't exist
            if (! Schema::hasColumn('media', 'path')) {
                $table->string('path')->after('handle');
            }

            if (! Schema::hasColumn('media', 'disk')) {
                $table->string('disk')->default('public')->after('handle');
            }

            if (! Schema::hasColumn('media', 'extension')) {
                $table->string('extension')->nullable()->after('path');
            }

            if (! Schema::hasColumn('media', 'hash')) {
                $table->string('hash')->nullable()->after('extension');
            }
        });
    }

    public function down(): void
    {
        Schema::table('media', function (Blueprint $table) {
            if (Schema::hasColumn('media', 'path')) {
                $table->dropColumn('path');
            }

            if (Schema::hasColumn('media', 'disk')) {
                $table->dropColumn('disk');
            }

            if (Schema::hasColumn('media', 'extension')) {
                $table->dropColumn('extension');
            }

            if (Schema::hasColumn('media', 'hash')) {
                $table->dropColumn('hash');
            }
        });
    }
};
