<x-daylight::dropdown :name="__('daylight::general.actions')">
    @if(is_null($user->email_verified_at))
        <x-daylight::dropdown-item wire:click.prevent="sendVerificationEmail">
            {{ __('daylight::general.send_verification_mail') }}
        </x-daylight::dropdown-item>
    @endif

    <x-daylight::dropdown-item wire:click.prevent="sendPasswordReset">
        {{ __('daylight::general.send_reset_password_mail') }}
    </x-daylight::dropdown-item>

    @if($user->mfa_secret)
        <x-daylight::dropdown-item wire:click.prevent="disableMfa">
            {{ __('daylight::general.disable_mfa') }}
        </x-daylight::dropdown-item>
    @endif

    @can('impersonate:users')
        <x-daylight::dropdown-divider />

        <x-daylight::dropdown-item wire:click.prevent="impersonate">
            {{ __('daylight::general.impersonate') }}
        </x-daylight::dropdown-item>
    @endcan
</x-daylight::dropdown>
