<?php

namespace Daylight\Core\Modules\Payment\Entities;

use Daylight\Core\Models\Order;
use Illuminate\Http\RedirectResponse;
use Illuminate\Routing\Redirector;

class PaymentIntent
{
    public function __construct(
        protected Order $order,
        public ?string $transactionId,
        public ?string $status,
        public ?string $redirectUrl,
    ) {
        //
    }

    public function getId(): ?string
    {
        return empty($this->transactionId)
            ? $this->order->number
            : $this->transactionId;
    }

    public function getStatus(): ?string
    {
        return empty($this->status)
            ? 'initialized'
            : $this->status;
    }

    public function redirect(): Redirector|RedirectResponse
    {
        return redirect($this->redirectUrl);
    }
}
