@props(['route'])
<div class="my-4">
    <div class="sm:hidden">
        <label for="tabs" class="mb-1 block text-sm text-gray-500">{{ __('daylight::general.select_locale') }}</label>
        <select id="tabs" name="tabs" class="block w-full rounded-md border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" @change="window.location.href = event.target.value;">
            @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                <option {{ request()->get('locale', app()->getLocale()) === $locale ? 'selected' : '' }} value="{{ $route }}?locale={{ $locale }}">
                    {{ strtoupper($locale) }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="hidden sm:flex items-center">
        <p class="text-sm text-gray-600">{{ __('daylight::general.locale') }}:</p>
        <nav class="ml-4 flex space-x-4" aria-label="Tabs">
            @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                <a href="{{ $route }}?locale={{ $locale }}" class="{{ request()->get('locale', app()->getLocale()) === $locale ? 'text-sky-700 bg-sky-100' : 'text-gray-500 hover:text-gray-700' }} rounded-md  px-3 py-2 text-sm font-medium hover:text-gray-700 flex items-center">
                    <img src="{{ daylightAsset('resources/assets/images/flags/'.$locale.'.svg') }}" alt="{{ $locale }}" class="h-5 w-5 rounded-full ring-2 ring-white mr-2">
                    {{ strtoupper($locale) }}
                </a>
            @endforeach
        </nav>
    </div>
</div>
