@extends('daylight::layouts.app')

@section('title', __('Order #:order', ['order' => $order->number]))

@section('content')
    <x-daylight::page-header :title="__('Order #:order', ['order' => $order->number])"/>

    <x-daylight::session-messages/>

    <x-daylight::input.group :label="__('Placed at')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $order->created_at->format('Y-m-d H:i:s') }}</p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Customer')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            @if($order->customer)
                <a href="{{ route('daylight.store.customers.show', $order->customer) }}" class="text-sky-700">
                    {{ $order->customer->name }}
                </a>
            @else
                {{ __('daylight::general.n_a') }}
            @endif
        </p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Placed by')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            @if($order->user)
                <a href="{{ route('daylight.store.users.show', $order->user) }}" class="text-sky-700">
                    {{ $order->user->fullName }}
                </a>
        <p class="text-gray-700 text-sm leading-6">E. {{ $order->user->email }}</p>
        @if($order->user->phone)
            <p class="text-gray-700 text-sm leading-6">T. {{ $order->user->phone }}</p>
            @endif
            @else
                {{ __('daylight::general.n_a') }}
            @endif
            </p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('daylight::general.status')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            <x-daylight::badge :class="$order->status->adminColor()">
                {{ $order->status->label() }}
            </x-daylight::badge>
        </p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('daylight::store.mail.payment_method')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            {{ $order->payment_method->label() }}
        </p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Shipping method')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            {{ $order->shipping_method->label() }}
        </p>
    </x-daylight::input.group>

    <div class="my-6">

        <div class="grid grid-cols-12 gap-8">
            <div class="col-span-8">
                <div class="grid grid-cols-12 gap-8">
                    <div class="col-span-12">
                        <h3 class="text-base font-semibold leading-7 text-gray-900 mb-3">{{ __('Articles (:articleCount)', ['articleCount' => $order->items->count()]) }}</h3>

                        <div class="space-y-4 divide-y">
                            @foreach($order->items as $item)
                                <div x-data="{ showOrderItemDetails: false }">
                                    <div class="grid grid-cols-12 gap-y-4 pt-4 items-center">
                                        <div class="col-span-6 flex items-center" >
                                            @if($item->variant?->getFirstMedia())
                                                <img src="{{ $item->variant->getFirstMedia()->getUrl('thumbnail') }}"
                                                     alt="{{ $item->variant?->product ? $item->variant->product->name : $item->variant->name }}"
                                                     class="w-20 h-20 object-cover border">
                                            @endif
                                            <div class="ml-4">
                                                <p class="text-sm leading-6 text-gray-900">{{ $item->variant?->product ? $item->variant?->product->name : $item->variant?->name }}</p>
                                                <p class="text-xs leading-6 text-gray-500">{{ $item->variant?->variationName }}</p>
                                                <p class="text-xs leading-6 text-gray-500">{{ $item->sku }}</p>
                                            </div>
                                        </div>
                                        <div class="col-span-2">
                                            <p class="text-sm leading-6 text-gray-700">&times; {{ $item->quantity }}</p>
                                        </div>
                                        <div class="col-span-2 text-right">
                                            <p class="text-sm leading-6 text-gray-700">{{ formatPrice($item->price) }}</p>
                                        </div>
                                        <div class="col-span-2 text-right">
                                            <p class="text-sm leading-6 text-gray-700">{{ formatPrice($item->quantity * $item->price) }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-12 gap-8 mt-6 bg-gray-100 rounded">
                    <div class="col-span-6 p-6">
                        <div class="grid grid-cols-2">
                            <p class="text-sm leading-6 text-gray-700">{{ __('Total weight') }}</p>
                            <p class="text-sm leading-6 text-gray-700 text-right">{{ formatNumber($order->items->map(fn($i) => $i->variant->weight ?? 0)->sum() / 1000, 2) }} kg</p>
                        </div>

                        <div class="grid grid-cols-2">
                            <p class="text-sm leading-6 text-gray-700">{{ __('Total volume') }}</p>
                            <p class="text-sm leading-6 text-gray-700 text-right">{{ formatNumber($order->items->map(fn($i) => $i->variant->volume ?? 0)->sum() / 1_000_000, 4) }} m3</p>
                        </div>
                    </div>

                    <div class="col-span-6 p-6">
                        <div class="grid grid-cols-2">
                            <p class="text-sm leading-6 text-gray-700">{{ __('daylight::store.mail.subtotal') }}</p>
                            <p class="text-sm leading-6 text-gray-700 text-right">{{ formatPrice($order->subtotal) }}</p>
                        </div>

                        <div class="grid grid-cols-2">
                            <p class="text-sm leading-6 text-gray-700">{{ __('daylight::store.mail.shipping') }}</p>
                            <p class="text-sm leading-6 text-gray-700 text-right">{{ formatPrice($order->shipping) }}</p>
                        </div>

                        @if($order->tax_breakdown)
                            @foreach($order->tax_breakdown as $tax)
                                <div class="grid grid-cols-2">
                                    <p class="text-sm leading-6 text-gray-700">
                                        {{ $tax['name'] }} ({{ floatval($tax['rate']) }}%)
                                    </p>
                                    <p class="text-sm leading-6 text-gray-700 text-right">{{ formatPrice($tax['amount'] / 100) }}</p>
                                </div>
                            @endforeach
                        @endif

                        @if($order->transaction_fee)
                            <div class="grid grid-cols-2">
                                <p class="text-sm leading-6 text-gray-700">{{ __('Transaction fee') }}</p>
                                <p class="text-sm leading-6 text-gray-700 text-right">{{ formatPrice($order->transaction_fee) }}</p>
                            </div>
                        @endif

                        <div class="grid grid-cols-2 font-semibold mt-4 text-lg">
                            <p class="leading-6 text-gray-700">{{ __('daylight::store.mail.total') }}</p>
                            <p class="leading-6 text-gray-700 text-right">{{ formatPrice($order->total) }}</p>
                        </div>
                    </div>
                </div>

                <div class="border-t mt-6 pt-6">
                    <div class="grid grid-cols-2 gap-6">
                        @if($order->billingAddress)
                            <div>
                                <h3 class="text-base font-semibold leading-7 text-gray-900 mb-3">
                                    {{ __('Billing address') }}
                                </h3>

                                <x-daylight::address :address="$order->billingAddress"/>
                            </div>
                        @endif

                        @if($order->shippingAddress)
                            <div>
                                <h3 class="text-base font-semibold leading-7 text-gray-900 mb-3">
                                    {{ __('Shipping address') }}
                                </h3>

                                <x-daylight::address :address="$order->shippingAddress" type="shipping"/>
                            </div>
                        @endif
                    </div>

                    @if($order->reference)
                        <p class="mt-6 text-sm leading-6 text-gray-700">{{ __('daylight::store.mail.reference') }}
                            : {{ $order->reference }}</p>
                    @endif

                    @if($order->notes)
                        <div class="mt-4">
                            <p class="text-sm leading-6 text-gray-900 text-semibold">{{ __('daylight::store.notes') }}</p>
                            <div class="text-sm leading-6 text-gray-600">
                                {{ $order->notes }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <div class="col-span-4">
                <h3 class="text-base font-semibold leading-7 text-gray-900 mb-3">{{ __('Order history') }}</h3>

                <div class="space-y-4">
                    @forelse($order->updates as $update)
                        <div class="bg-gray-100 rounded-lg p-4 text-gray-700 text-sm relative">
                            {!! $update->content !!}

                            <div class="mt-1 text-xs text-gray-400">
                                {{ $update->created_at->format('d-m-Y H:i:s') }}
                                @if($update->type !== 'system')
                                    &mdash; {{ ucfirst($update->type) }}
                                @endif
                                @if($update->user)
                                    {{ __('by') }} {{ $update->user->fullName }}
                                @endif
                            </div>
                        </div>
                    @empty
                        <p class="text-sm text-gray-700">
                            {{ __('No updates yet.') }}
                        </p>
                    @endforelse
                </div>

            </div>
        </div>
    </div>
@endsection
