<?php

namespace Daylight\Core\Modules\Cart\Http\Middleware;

use Closure;
use Daylight\Core\Modules\Cart\Contracts\CartInterface;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureCartSessionCreated
{
    public function __construct(
        protected CartInterface $cart
    ) {
        //
    }

    public function handle(Request $request, Closure $next): Response
    {
        if (! $this->cart->exists()) {
            $this->cart->create($request->user());
        }

        return $next($request);
    }
}
