<?php

namespace Daylight\Core\Modules\MediaLibrary\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreMediaRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('create:media');
    }

    public function rules(): array
    {
        return [
            'currentDirectory' => ['nullable', 'exists:directories,id'],
            'files' => ['required', 'array'],
            'files.*.filePath' => ['required'],
            'files.*.originalFile' => ['required', 'array'],
            'files.*.originalFile.size' => ['required'],
            'files.*.originalFile.mime' => ['required'],
            'files.*.originalFile.originalFileName' => ['required'],
        ];
    }
}
