<?php

namespace Daylight\Core\Modules\MenuBuilder\Livewire;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithMultilingualism;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Modules\MenuBuilder\Models\Menu;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class MenuTable extends BaseTable
{
    use WithMultilingualism;
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Menu::query()->with('translations');
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->whereHas('translations', function ($query) use ($searchQuery) {
                $query->where('name', 'like', "%{$searchQuery}%");
            });
        });
    }

    protected function applyMultilingualism(Builder $query, ?string $locale): Builder
    {
        return $query->withWhereHas('translations', function ($query) use ($locale) {
            $query->where('locale', $locale);
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.settings.menu-table');
    }
}
