<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->uuid();

            $table->foreignId('customer_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();

            $table->string('number')->unique();

            $table->string('shipping_method')->default('shipping');
            $table->string('payment_method');
            $table->string('payment_gateway_id')->nullable();

            $table->string('status')->default('pending');
            $table->string('payment_gateway_status')->nullable();

            $table->integer('subtotal');
            $table->integer('shipping');
            $table->integer('tax');
            $table->integer('transaction_fee')->default(0);
            $table->integer('total');

            $table->string('reference')->nullable();
            $table->text('notes')->nullable();

            $table->json('tax_breakdown')->nullable();

            $table->dateTime('confirmation_send_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
