<?php

namespace Daylight\Core\Database\Seeders;

use Daylight\Core\Modules\MenuBuilder\Models\Menu;
use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Illuminate\Database\Seeder;

class NavigationSeeder extends Seeder
{
    public function run(): void
    {
        $menus = [
            'Primary Navigation',
            'Secondary Navigation',
        ];

        foreach ($menus as $menuName) {
            $menu = Menu::create([
                'name' => $menuName,
            ]);

            Multilingualism::getAvailableLocales()->each(function ($locale) use ($menu) {
                $translation = $menu->translations()->create([
                    'locale' => $locale,
                ]);

                for ($i = 1; $i <= 3; $i++) {
                    $translation->items()->create([
                        'name' => "Menu item {$i}",
                        'url' => '#',
                    ]);
                }
            });
        }
    }
}
