<?php

namespace Daylight\Core\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\LaravelSettings\Migrations\SettingsMigrator;

class SettingsSeeder extends Seeder
{
    protected SettingsMigrator $migrator;

    public function __construct()
    {
        $this->migrator = app(SettingsMigrator::class);
    }

    public function run(): void
    {
        $this->migrator->add('general.frontPage', 1);
        $this->migrator->add('general.name', 'Daylight E-Commerce Core');
        $this->migrator->add('general.vatNumber', '-');
        $this->migrator->add('general.addressLine1', 'Aanwas 35');
        $this->migrator->add('general.addressLine2', '');
        $this->migrator->add('general.postalCode', '4704 SC');
        $this->migrator->add('general.city', 'Roosendaal');
        $this->migrator->add('general.country', 'nl');
        $this->migrator->add('general.email', 'support@every-day.nl');
        $this->migrator->add('general.phoneNumber', '+31 085 021 11 21');
        $this->migrator->add('general.linkedinUrl', '');
        $this->migrator->add('general.instagramUrl', '');
        $this->migrator->add('general.youtubeUrl', '');
        $this->migrator->add('general.facebookUrl', '');
        $this->migrator->add('navigation.menus');
    }
}
