# Installation

## Configuring Bytescale

Add the following lines to your `config/services.php`

```php
'bytescale' => [
    'url' => env('BYTESCALE_API_URL', 'https://api.bytescale.com'),
    'account_id' => env('BYTESCALE_ACCOUNT_ID'),
    'private_key' => env('BYTESCALE_PRIVATE_KEY'),
    'public_key' => env('BYTESCALE_PUBLIC_KEY'),
    'path' => env('BYTESCALE_FOLDER_PATH'),
    'cdn_url' => env('BYTESCALE_CDN_URL'),
],
```

Configure at least the following properties within your `.env` file:

```dotenv
BYTESCALE_ACCOUNT_ID=your_account_id
BYTESCALE_PRIVATE_KEY=your_private_key
BYTESCALE_PUBLIC_KEY=your_public_key
BYTESCALE_FOLDER_PATH=your_folder_path
BYTESCALE_CDN_URL="https://cdn.example.com"
```