import slug from 'alpinejs-slug'
import {Livewire, Alpine} from '../../../vendor/livewire/livewire/dist/livewire.esm';
import {createApp} from 'vue'
import MediaLibrary from "./modules/MediaLibrary/MediaLibrary.vue";
import {createRouter, createWebHashHistory} from 'vue-router'
import MediaSelector from "./modules/MediaLibrary/MediaSelector.vue";
import MenuBuilder from "./modules/MenuBuilder/MenuBuilder.vue";
import PageBuilder from "./modules/PageBuilder/PageBuilder.vue";

import.meta.glob([
    '../images/**',
]);

Alpine.plugin(slug)
Livewire.start()

document.addEventListener('DOMContentLoaded', () => {
    const appContainers = document.querySelectorAll('[data-vue-app]')

    appContainers.forEach(el => {
        const app = createApp({})

        app.use(createRouter({
            history: createWebHashHistory(),
            routes: [
                {path: '/', name: 'default', component: MediaLibrary},
            ],
        }));

        app.component('media-library', MediaLibrary)
        app.component('media-selector', MediaSelector)
        app.component('menu-builder', MenuBuilder)
        app.component('page-builder', PageBuilder)

        app.mount(el)
    });
})