@props([
    'disabled' => false,
    'readonly' => false,
    'type' => 'textarea',
    'helper' => ''
])

<div>
    <div>
        <div class="flex mb-1">
            <span onmousedown="saveSelection()" onclick="formatText('bold')" class="cursor-pointer border rounded hover:bg-gray-200 transition p-2 mr-1">
                <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M8 11H12.5C13.8807 11 15 9.88071 15 8.5C15 7.11929 13.8807 6 12.5 6H8V11ZM18 15.5C18 17.9853 15.9853 20 13.5 20H6V4H12.5C14.9853 4 17 6.01472 17 8.5C17 9.70431 16.5269 10.7981 15.7564 11.6058C17.0979 12.3847 18 13.837 18 15.5ZM8 13V18H13.5C14.8807 18 16 16.8807 16 15.5C16 14.1193 14.8807 13 13.5 13H8Z"></path></svg>
            </span>
            <span onmousedown="saveSelection()" onclick="formatText('italic')" class="cursor-pointer border rounded hover:bg-gray-200 transition p-2 mr-1">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M5.248 20.246H9.05m0 0h3.696m-3.696 0 5.893-16.502m0 0h-3.697m3.697 0h3.803" /></svg>
            </span>
            <span onmousedown="saveSelection()" onclick="formatText('underline')" class="cursor-pointer border rounded hover:bg-gray-200 transition p-2 mr-1">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" class="w-4 h-4"><path stroke-linecap="round" stroke-linejoin="round" d="M17.995 3.744v7.5a6 6 0 1 1-12 0v-7.5m-2.25 16.502h16.5" /></svg>
            </span>
            <span onmousedown="saveSelection()" onclick="formatText('insertUnorderedList')" class="cursor-pointer border rounded hover:bg-gray-200 transition p-2 mr-1">
                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M8 4H21V6H8V4ZM4.5 6.5C3.67157 6.5 3 5.82843 3 5C3 4.17157 3.67157 3.5 4.5 3.5C5.32843 3.5 6 4.17157 6 5C6 5.82843 5.32843 6.5 4.5 6.5ZM4.5 13.5C3.67157 13.5 3 12.8284 3 12C3 11.1716 3.67157 10.5 4.5 10.5C5.32843 10.5 6 11.1716 6 12C6 12.8284 5.32843 13.5 4.5 13.5ZM4.5 20.4C3.67157 20.4 3 19.7284 3 18.9C3 18.0716 3.67157 17.4 4.5 17.4C5.32843 17.4 6 18.0716 6 18.9C6 19.7284 5.32843 20.4 4.5 20.4ZM8 11H21V13H8V11ZM8 18H21V20H8V18Z"></path></svg>
            </span>
            <span onmousedown="saveSelection()" onclick="insertLink()" class="cursor-pointer border rounded hover:bg-gray-200 transition p-2 mr-1">
                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M18.3638 15.5355L16.9496 14.1213L18.3638 12.7071C20.3164 10.7545 20.3164 7.58866 18.3638 5.63604C16.4112 3.68341 13.2453 3.68341 11.2927 5.63604L9.87849 7.05025L8.46428 5.63604L9.87849 4.22182C12.6122 1.48815 17.0443 1.48815 19.778 4.22182C22.5117 6.95549 22.5117 11.3876 19.778 14.1213L18.3638 15.5355ZM15.5353 18.364L14.1211 19.7782C11.3875 22.5118 6.95531 22.5118 4.22164 19.7782C1.48797 17.0445 1.48797 12.6123 4.22164 9.87868L5.63585 8.46446L7.05007 9.87868L5.63585 11.2929C3.68323 13.2455 3.68323 16.4113 5.63585 18.364C7.58847 20.3166 10.7543 20.3166 12.7069 18.364L14.1211 16.9497L15.5353 18.364ZM14.8282 7.75736L16.2425 9.17157L9.17139 16.2426L7.75717 14.8284L14.8282 7.75736Z"></path></svg>
            </span>
            <span onclick="clearFormat()" class="cursor-pointer border rounded hover:bg-gray-200 transition p-2">
                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" /></svg>
            </span>
        </div>

        <textarea
            {{ $disabled ? 'disabled' : '' }}
            {{ $readonly ? 'readonly' : '' }}
            {!! $attributes->merge(['class' => 'border p-3 rounded focus:outline-none min-h-[200px] w-full py-1.5 text-gray-900 shadow-sm placeholder:text-gray-400 sm:max-w-lg sm:text-sm sm:leading-6 border-gray-300', 'contenteditable' => 'true']) !!}
        >{{ $slot }}</textarea>
    </div>
</div>
@if($helper)
    <p class="flex items-start mt-2 text-xs text-slate-400">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-5 h-5 mr-1.5">
            <path fill-rule="evenodd" d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12ZM12 8.25a.75.75 0 0 1 .75.75v3.75a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75Zm0 8.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" clip-rule="evenodd" />
        </svg>
        {{ $helper }}
    </p>
@endif

<script>
    let savedSelection = null;

    function saveSelection() {
        const selection = window.getSelection();
        if (selection.rangeCount > 0) {
            savedSelection = selection.getRangeAt(0);
        }
    }

    function formatText(command) {
        if (!savedSelection) return;

        const selection = window.getSelection();
        selection.removeAllRanges();
        selection.addRange(savedSelection);

        let range = selection.getRangeAt(0);
        let span = document.createElement("span");

        switch (command) {
            case "bold":
                span.style.fontWeight = "bold";
                break;
            case "italic":
                span.style.fontStyle = "italic";
                break;
            case "underline":
                span.style.textDecoration = "underline";
                break;
            case "strikeThrough":
                span.style.textDecoration = "line-through";
                break;
        }

        span.appendChild(range.extractContents());
        range.insertNode(span);

        selection.removeAllRanges();
        let newRange = document.createRange();
        newRange.selectNodeContents(span);
        newRange.collapse(false);
        selection.addRange(newRange);

        savedSelection = null;
    }

    function insertLink() {
        if (!savedSelection) return;

        const selection = window.getSelection();
        selection.removeAllRanges();
        selection.addRange(savedSelection);

        let url = prompt("Voer de URL in:");
        if (url) {
            let range = selection.getRangeAt(0);
            let link = document.createElement("a");
            link.href = url;
            link.target = "_blank";
            link.style.color = "blue";
            link.appendChild(range.extractContents());
            range.insertNode(link);

            selection.removeAllRanges();
            let newRange = document.createRange();
            newRange.selectNodeContents(span);
            newRange.collapse(false);
            selection.addRange(newRange);

            savedSelection = null;
        }
    }

    function clearFormat() {
        const editor = document.getElementById("editor");
        editor.innerHTML = editor.innerText;
    }
</script>
