@props(['page' => null])
<div>
    <h2 class="mt-12">SEO</h2>

    <x-daylight::input.group
        :label="__('Robots')"
        :error="$errors->first('robots')"
        for="robots"
    >
        <x-daylight::input.select name="robots" id="robots">
            <option value="index, follow" {{ old('robots', $page?->robots) === 'index, follow' ? 'selected' : '' }}>
                Default (index, follow)
            </option>
            <option value="nofollow" {{ old('robots', $page?->robots) === 'nofollow' ? 'selected' : '' }}>
                nofollow
            </option>
            <option value="noindex" {{ old('robots', $page?->robots) === 'noindex' ? 'selected' : '' }}>
                noindex
            </option>
            <option value="noindex, nofollow" {{ old('robots', $page?->robots) === 'noindex, nofollow' ? 'selected' : '' }}>
                noindex, nofollow
            </option>
        </x-daylight::input.select>
    </x-daylight::input.group>

    <x-daylight::input.group
        :label="__('Title')"
        :error="$errors->first('meta_title')"
        for="meta_title"
    >
        <x-daylight::input.text name="meta_title" id="meta_title" value="{{ old('meta_title', $page?->meta_title) }}"/>
    </x-daylight::input.group>

    <x-daylight::input.group
        :label="__('Description')"
        :error="$errors->first('meta_description')"
        for="meta_description"
    >
        <x-daylight::input.textarea name="meta_description" id="meta_description">
            {{ old('meta_description', $page?->meta_description) }}
        </x-daylight::input.textarea>
    </x-daylight::input.group>
</div>
