@extends('daylight::layouts.app')

@section('title', __('Edit attribute'))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit attribute')">
            @can('delete:attributes')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete attribute') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.store.attributes.update', $attribute) }}">
            @csrf
            @method('PUT')

            <x-daylight::input.group
                    :label="__('Key')"
                    :error="$errors->first('key')"
                    for="key"
                    :helpText="__('The key can only be changed manually after creation for prevent filtering issues.')"
            >
                <x-daylight::input.text
                    name="key"
                    id="key"
                    value="{{ old('key', $attribute->key) }}"
                    :disabled="!auth()->user()->can('update:attributes')"
                    readonly
                    :helpText="__('Please note this does not show the filter on the product pages by default. This is a manual change.')"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Category')"
                :error="$errors->first('category')"
                for="category_id"
            >
                <div x-data="{ activeCategories: @json(old('categories', $attribute->categories->pluck('id'))) }">
                    <select multiple x-model="activeCategories">
                        @foreach($categories as $category)
                            @include('daylight::store.categories.partials.option', ['parent' => $category, 'level' => 0])
                        @endforeach
                    </select>

                    <div class="hidden">
                        <template x-for="category in activeCategories">
                            <input type="text" name="categories[]" x-bind:value="category">
                        </template>
                    </div>
                </div>
            </x-daylight::input.group>

            <x-daylight::input.group
                    :label="__('Filterable')"
                    :error="$errors->first('filterable')"
                    for="default"
                    :helpText="__('Please note this does not show the filter on the product pages by default. This is a manual change.')"
            >
                <div x-data="{ selected: {{ old('filterable', $attribute->filterable) ? '1' : '0' }}}">
                    <div class="flex items-center mt-1">
                        <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                                @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                                class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                                role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                        </button>
                        <span class="ml-3 text-sm font-medium text-gray-900"
                              id="annual-billing-label">{{ __('Filterable') }}</span>
                    </div>

                    <input type="hidden" name="filterable" x-model="selected">
                </div>
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Visible')"
                :error="$errors->first('visible')"
                for="default"
            >
                <div x-data="{ selected: {{ old('visible', $attribute->visible) ? '1' : '0' }}}">
                    <div class="flex items-center mt-1">
                        <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                                @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                                class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                                role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                        </button>
                        <span class="ml-3 text-sm font-medium text-gray-900"
                              id="annual-billing-label">{{ __('Visible on product detail pages') }}</span>
                    </div>

                    <input type="hidden" name="visible" x-model="selected">
                </div>
            </x-daylight::input.group>


            <div class="mt-6">
                <h2 class="text-lg leading-loose font-medium">{{ __('Translations') }}</h2>
            </div>

            @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                <x-daylight::input.group
                        :label="__('Name (:locale)', ['locale' => strtoupper($locale)])"
                        :error="$errors->first('translations.' . $locale . '.name')"
                        for="translations[{{ $locale }}][name]"
                >
                    <x-daylight::input.text
                            name="translations[{{ $locale }}][name]"
                            id="translations[{{ $locale }}][name]"
                            value="{{ old('translations.' . $locale . '.name', $attribute->translations->firstWhere('locale', $locale)->name) }}"
                            :disabled="!auth()->user()->can('update:attributes')"
                    />
                </x-daylight::input.group>
            @endforeach

            <div class="mt-6">
                <h2 class="text-lg leading-loose font-medium">{{ __('Values') }}</h2>
            </div>

            <x-daylight::input.group
                    :label="__('Values')"
                    :error="$errors->first('values')"
                    for="values"
            >
                <div class="grid grid-cols-{{ \Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales()->count() }} gap-4 mt-6 text-gray-500 text-sm">
                    @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                        <div>
                            {{ strtoupper($locale) }}
                        </div>
                    @endforeach
                </div>

                <div class="divide-y space-y-2 mt-2" x-data='{
                                values:
                                    {{
                                        old('values')
                                            ? json_encode(old('values'))
                                            : json_encode($attribute->values->map(function($attributeValue) {
                                                return [
                                                    'id' => $attributeValue->id,
                                                    'translations' => $attributeValue->translations->keyBy('locale')->map->only(['name'])->toArray()
                                                ];
                                            })->values()->toArray())
                                    }}
                           }'
                >
                    <template x-for="(value, index) in values" :key="index">
                        <div class="grid grid-cols-{{ \Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales()->count() }} py-1 gap-4">
                            <input type="hidden"
                                   x-bind:name="`values[${index}][id]`"
                                   x-bind:value="value.id">

                            @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                                <div class="mt-2 flex items-center justify-between gap-4">

                                    <x-daylight::input.text
                                            type="text"
                                            x-bind:name="`values[${index}][translations][{{ $locale }}][name]`"
                                            x-model="value.translations.{{ $locale }}.name"
                                            class="w-full !max-w-full mt-2"/>

                                    @if($loop->last)
                                        <button class="min-w-8 flex-grow w-8 h-8 bg-red-600 text-white flex items-center justify-center rounded-full hover:bg-red-800" @click.prevent="values.splice(index, 1)">
                                            <svg class="w-4 h-4" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0"></path>
                                            </svg>
                                        </button>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </template>

                    <div x-show="values.length === 0">
                        <div class="rounded-md bg-blue-50 p-4 my-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor"
                                         aria-hidden="true">
                                        <path fill-rule="evenodd"
                                              d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a.75.75 0 000 1.5h.253a.25.25 0 01.244.304l-.459 2.066A1.75 1.75 0 0010.747 15H11a.75.75 0 000-1.5h-.253a.25.25 0 01-.244-.304l.459-2.066A1.75 1.75 0 009.253 9H9z"
                                              clip-rule="evenodd"/>
                                    </svg>
                                </div>
                                <div class="ml-3 flex-1 md:flex md:justify-between">
                                    <p class="text-sm text-blue-700">{{ __('No values configured for this attribute.') }}</p>
                                </div>
                            </div>
                        </div>

                    </div>

                    <x-daylight::buttons.primary class="mt-4" @click.prevent="values.push({id: null, translations: { en: null, nl: null }})">
                        {{ __('Add value') }}
                    </x-daylight::buttons.primary>
                </div>
            </x-daylight::input.group>

            @can('update:brands')
                <div class="mt-6 flex items-center justify-end gap-x-3">
                    <x-daylight::buttons.secondary href="{{ route('daylight.store.attributes.index') }}" element="a">
                        {{ __('Cancel') }}
                    </x-daylight::buttons.secondary>

                    <x-daylight::buttons.primary type="submit">
                        {{ __('Save') }}
                    </x-daylight::buttons.primary>
                </div>
            @endcan
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900"
                    id="modal-title">{{ __('Delete :object', ['object' => __('attribute')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('attribute')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.store.attributes.destroy', $attribute) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto"
                            @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
