@extends('daylight::layouts.app')

@section('title', __('Create brand'))

@section('content')
    <x-daylight::page-header :title="__('Create brand')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.store.categories.store') }}">
        @csrf

        <input type="hidden" name="locale" value="{{ request()->get('locale', 'en') }}">

        <x-daylight::input.group
            :label="__('Parent')"
            :error="$errors->first('parent')"
            for="parent_id"
        >
            <x-daylight::input.select name="parent_id" id="parent_id" :disabled="!auth()->user()->can('update:categories')">
                <option value="">{{ __('No parent') }}</option>
                @foreach($parents as $parent)
                    @include('daylight::store.categories.partials.parent', ['parent' => $parent, 'level' => 0])
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::locale-selector :route="route('daylight.store.categories.create')"/>

        <div x-data="{ name: '{{ old('name') }}', slug: '{{ old('slug') }}' }">
            <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="code"
            >
                <x-daylight::input.text
                    name="name"
                    id="name"
                    value="{{ old('name') }}"
                    :disabled="!auth()->user()->can('update:categories')"
                    x-model="name"
                />
            </x-daylight::input.group>

            <x-daylight::input.group
                :label="__('Slug')"
                :error="$errors->first('slug')"
                for="slug"
            >
                <x-daylight::input.text
                    name="slug"
                    id="slug"
                    value="{{ old('slug') }}"
                    :disabled="!auth()->user()->can('update:categories')"
                    x-slug="name"
                />
            </x-daylight::input.group>
        </div>

        <x-daylight::seo />

        <div>
            <h2 class="mt-12">{{ __('Components') }}</h2>
            <x-daylight::input.group
                    :label="__('Components')"
                    :error="$errors->first('components')"
                    for="components"
            >
                <div wire:ignore>
                    <div data-vue-app>
                        <page-builder
                                :components='@json(old('components', $components ?? collect()))'
                                :available-components='@json($availableComponents)'
                        />
                    </div>
                </div>
            </x-daylight::input.group>
        </div>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.store.brands.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
