<?php

namespace Daylight\Core\Http\Requests\Content\Pages;

use Daylight\Core\Http\Requests\Concerns\HandlesSeoRequest;
use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Daylight\Core\Modules\PageBuilder\Concerns\InteractsWithPageBuilder;
use Daylight\Core\Modules\PageBuilder\Contracts\HasPageBuilder;
use Daylight\Core\Modules\PageBuilder\Registries\TemplateRegistry;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdatePageRequest extends FormRequest implements HasPageBuilder
{
    use HandlesSeoRequest;
    use InteractsWithPageBuilder;

    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:pages');
    }

    public function rules(): array
    {
        $templates = app(TemplateRegistry::class)->all();

        return [
            'locale' => ['required', 'string', Rule::in(Multilingualism::getAvailableLocales())],
            'name' => ['required', 'string', 'max:255'],
            'slug' => ['required', 'string', 'max:255'],
            ...$templates->isNotEmpty()
                ? ['template' => ['required', 'string', Rule::in($templates->keys())]]
                : ['template' => ['nullable', 'string']],
            ...$this->getPageBuilderRules(),
            ...$this->getSeoRules(),
        ];
    }
}
