<?php

namespace Daylight\Core\Http\Requests\Settings\Countries;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use PeterColes\Countries\CountriesFacade;

class UpdateCountryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:settings');
    }

    public function rules(): array
    {
        $countries = CountriesFacade::lookup(app()->getLocale())->keys();

        return [
            'code' => ['required', 'string', Rule::in($countries)],
            'default' => ['required', 'integer', 'min:0', 'max:1'],
            'taxRates' => ['required', 'array'],
            'taxRates.*.name' => ['required', 'string'],
            'taxRates.*.rate' => ['required', 'numeric'],
        ];
    }

    public function attributes()
    {
        return [
            'taxRates.*.name' => 'name',
            'taxRates.*.rate' => 'rate',
        ];
    }
}
